#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_ret32_I16fix0(int seg,Bit8u* imm)
{
Bit32u temp_ESP;
Bit32u return_EIP;
Bit16u arg0;



arg0=0;

#if BX_DEBUGGER
BX_CPU_THIS_PTR show_flag |= Flag_ret;
#endif
if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.d_b) /* 32bit stack */
  temp_ESP = ESP;
else
  temp_ESP = SP;
invalidate_prefetch_q();
if (protected_mode()) {
  if ( !can_pop(4) ) {
    BX_PANIC(("retnear_iw: can't pop IP\n"));
    /* ??? #SS(0) -or #GP(0) */
  }
  access_linear(BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.base + temp_ESP + 0,
                4, CPL==3, BX_READ, &return_EIP);

  if (protected_mode() &&
      (return_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled) ) {
    BX_DEBUG(("retnear_iw: EIP > limit\n"));
    exception(BX_GP_EXCEPTION, 0, 0);
  }
  if ( arg0!=0 && !can_pop(4 + arg0) ) {
    BX_PANIC(("retnear_iw: can't release bytes from stack\n"));
    /* #GP(0) -or #SS(0) ??? */
  }
  BX_CPU_THIS_PTR eip = return_EIP;
  if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.d_b) /* 32bit stack */
    ESP += 4 + arg0; /* ??? should it be 2*imm16 ? */
  else
    SP  += 4 + arg0;
  } else {
    pop_32(&return_EIP);
    BX_CPU_THIS_PTR eip = return_EIP;
    if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.d_b) /* 32bit stack */
    ESP += arg0; /* ??? should it be 2*imm16 ? */
  else
    SP  += arg0;
  }
  BX_INSTR_UCNEAR_BRANCH(BX_INSTR_IS_RET, BX_CPU_THIS_PTR eip);
}

void BX_CPU_C::EXEC_ret32_I16imm(int seg,Bit8u* imm)
{
Bit32u temp_ESP;
Bit32u return_EIP;
Bit16u arg0;
Bit16u immdat;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
immdat=*(imm+0);
immdat|=(*(imm+0+1))<<8;
#else
immdat=*((Bit16u*)(imm+0));
#endif


arg0=immdat;

#if BX_DEBUGGER
BX_CPU_THIS_PTR show_flag |= Flag_ret;
#endif
if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.d_b) /* 32bit stack */
  temp_ESP = ESP;
else
  temp_ESP = SP;
invalidate_prefetch_q();
if (protected_mode()) {
  if ( !can_pop(4) ) {
    BX_PANIC(("retnear_iw: can't pop IP\n"));
    /* ??? #SS(0) -or #GP(0) */
  }
  access_linear(BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.base + temp_ESP + 0,
                4, CPL==3, BX_READ, &return_EIP);

  if (protected_mode() &&
      (return_EIP > BX_CPU_THIS_PTR sregs[BX_SEG_REG_CS].cache.u.segment.limit_scaled) ) {
    BX_DEBUG(("retnear_iw: EIP > limit\n"));
    exception(BX_GP_EXCEPTION, 0, 0);
  }
  if ( arg0!=0 && !can_pop(4 + arg0) ) {
    BX_PANIC(("retnear_iw: can't release bytes from stack\n"));
    /* #GP(0) -or #SS(0) ??? */
  }
  BX_CPU_THIS_PTR eip = return_EIP;
  if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.d_b) /* 32bit stack */
    ESP += 4 + arg0; /* ??? should it be 2*imm16 ? */
  else
    SP  += 4 + arg0;
  } else {
    pop_32(&return_EIP);
    BX_CPU_THIS_PTR eip = return_EIP;
    if (BX_CPU_THIS_PTR sregs[BX_SEG_REG_SS].cache.u.segment.d_b) /* 32bit stack */
    ESP += arg0; /* ??? should it be 2*imm16 ? */
  else
    SP  += arg0;
  }
  BX_INSTR_UCNEAR_BRANCH(BX_INSTR_IS_RET, BX_CPU_THIS_PTR eip);
}
